/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.api.config;

import com.flemmli97.tenshilib.api.config.SimpleItemStackWrapper;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class ItemTagWrapper
extends SimpleItemStackWrapper {
    private String tag;
    private List<Item> list;

    public ItemTagWrapper(String tagName) {
        this(tagName, 1);
    }

    public ItemTagWrapper(String tagName, int count) {
        super("", count);
        this.tag = tagName;
    }

    @Override
    public Item getItem() {
        ITag tags = ItemTags.func_199903_a().func_241834_b(new ResourceLocation(this.tag));
        this.list = tags.func_230236_b_();
        this.item = !this.list.isEmpty() ? this.list.get(0) : Items.field_190931_a;
        return this.item;
    }

    @Override
    public List<Item> getItemList() {
        return this.list;
    }

    @Override
    public boolean hasList() {
        return true;
    }

    @Override
    public ItemTagWrapper readFromString(String s) {
        String[] parts = s.split(",");
        this.tag = parts[0];
        this.count = parts.length < 2 ? 1 : Integer.parseInt(parts[1]);
        return this;
    }

    @Override
    public String writeToString() {
        return this.tag + (this.count != 1 ? "," + this.count : "");
    }

    public static String usage() {
        return "Usage: item-tag,<amount>";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemTagWrapper) {
            ItemTagWrapper prop = (ItemTagWrapper)obj;
            return prop.writeToString().equals(this.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.writeToString().hashCode();
    }

    public static class Serializer
    implements JsonDeserializer<ItemTagWrapper>,
    JsonSerializer<ItemTagWrapper> {
        public JsonElement serialize(ItemTagWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("tag", (JsonElement)new JsonPrimitive(src.tag));
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            return obj;
        }

        public ItemTagWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int count = 1;
            if (obj.get("count") instanceof JsonPrimitive && obj.get("count").getAsJsonPrimitive().isNumber()) {
                count = obj.get("count").getAsInt();
            }
            return new ItemTagWrapper(obj.get("tag").getAsString(), count);
        }
    }
}

